using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.EFR.BO;

namespace VIRP.EFR.DAL
{
	public partial class EFR_PATIENTDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public EFR_PATIENTDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public EFR_PATIENT GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
		{
			EFR_PATIENT objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_EFR_PATIENT_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID).FirstOrDefault();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public List<EFR_PATIENT> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
		{
			List<EFR_PATIENT> objReturn = null;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					objReturn = dbContext.usp_EFR_PATIENT_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		public int Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, EFR_PATIENT objSave)
		{
			Int32? objReturn = objSave.PATIENT_ID;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_EFR_PATIENT_save(CURRENT_USER, CURRENT_REGISTRY_ID, objSave.ADDRESS_LINE1, objSave.ADDRESS_LINE2, objSave.ADDRESS_LINE3, objSave.ADDRESS_TYPE, objSave.BIRTH_DATE, objSave.CELL_PHONE, objSave.CITY, objSave.COUNTRY, objSave.COUNTY, DateTime.Now, objSave.CREATEDBY, objSave.DEATH_DATE, objSave.DOD_PATIENT_ID, objSave.EMAIL_ADDRESS, objSave.FIRST_NAME, objSave.HOME_PHONE, objSave.LAST_NAME, objSave.LastServiceSeparationDate, objSave.LIVING_ARRANGEMENT_TEXT, objSave.MIDDLE_NAME, objSave.OEF_OIF_IND, objSave.OEF_OIF_LOCATION, objSave.PATIENT_EDIPI, objSave.PATIENT_ICN, ref objReturn, objSave.PatientICNCheckSUM, objSave.POSTAL_CODE, objSave.PreferredContactMethod, objSave.PRIMARY_PHONE, objSave.SERVICE_STATUS, objSave.SSN, objSave.STATE, objSave.STD_COMBATLOCATION_ID, objSave.STD_ETHNICITY_ID, objSave.STD_GENDER_ID, objSave.STD_INSTITUTION_ID, objSave.STD_MARITALSTATUS_ID, objSave.STD_RACE_ID, objSave.STD_SERVICEBRANCH_ID, DateTime.Now, objSave.UPDATEDBY, objSave.VPID_NUMBER, objSave.WORK_PHONE, objSave.ZIP_PLUS_4);
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn.GetValueOrDefault();
		}

		public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 PATIENT_ID)
		{
			Boolean objReturn = false;

			try
			{
				using (EFRDBDataContext dbContext = GetEfrDataContext())
				{
					LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
					dbContext.usp_EFR_PATIENT_delete(CURRENT_USER, CURRENT_REGISTRY_ID, PATIENT_ID);
					objReturn = true;
					LogManager.LogTiming(logDetails);
				}
			}
			catch (Exception ex)
			{
				LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
				throw ex;
			}

			return objReturn;
		}

		#endregion
	}
}
